/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.viewer;

import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.animationdp.impl2.VWSIMAnimationDP;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMSession;
import filenet.sim.apps.viewer.VWSIMAnimatorSetPlaybackRateDialog;
import filenet.sim.apps.viewer.images.VWSIMImageLoader;
import filenet.sim.apps.viewer.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorTreePane;
import filenet.sim.toolkit.viewer.animation.IVWSIMAnimationUpdateListener;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationController;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationUpdateEvent;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorWorkflowPane;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.event.VWToolbarActionNotifier;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class VWSIMAnimatorCore
extends VWBaseCore
implements ItemListener,
WindowListener,
ActionListener,
MenuListener,
IVWSIMAnimationUpdateListener,
IVWToolbarActionListener,
MouseListener {
    VWSIMAnimatorCore m_theCore = null;
    private String m_productName = null;
    private IVWSIMAnimationDP m_animationDP = null;
    private VWSIMAnimatorDataModel m_animatorDataModel = null;
    private VWSessionInfo m_sessionInfo = null;
    private Runnable m_initRunnable = null;
    private Thread m_initThread = null;
    private boolean m_bAnimateThreadsStarted = false;
    private Thread[] m_animateThread = null;
    private Runnable m_animateRunnable = null;
    private Thread m_statPanelUpdateThread = null;
    private Runnable m_statPanelUpdateRunnable = null;
    private boolean m_bExit = false;
    private static final int PROGRESS_NONE = 0;
    private static final int PROGRESS_PLAYING = 1;
    private static final int PROGRESS_PAUSED = 2;
    private static final int PROGRESS_STOPPED = 3;
    private static final int PROGRESS_COMPLETED = 4;
    private Thread m_timeUpdateThread = null;
    private Runnable m_timeUpdateRunnable = null;
    private boolean m_bNeedUpdate = false;
    private Object m_updateObject = new Object();
    private int m_progress = 0;
    private boolean m_bUpdateEndTime = false;
    private static ImageIcon s_completedIcon = VWSIMImageLoader.createImageIcon("completed.gif");
    private static ImageIcon s_playingIcon = VWSIMImageLoader.createImageIcon("playing.gif");
    private static ImageIcon s_pausedIcon = VWSIMImageLoader.createImageIcon("paused.gif");
    private static ImageIcon s_stoppedIcon = VWSIMImageLoader.createImageIcon("stopped.gif");
    private VWSIMAnimationController m_animationController = null;
    private RootSplitPane m_rootSplitPane = null;
    private ViewSplitPane m_viewSplitPane = null;
    private VWSIMAnimatorWorkflowPane m_animatorWorkflowPane = null;
    private VWSIMStatisticsPanel m_statisticsPane = null;
    private VWSIMAnimatorTreePane m_mapTreePane = null;
    private JMenu m_fileMenu = null;
    private JMenuItem m_exitItem = null;
    private JMenu m_animationMenu = null;
    private JMenuItem m_startMenuItem = null;
    private JMenuItem m_stopMenuItem = null;
    private JMenuItem m_pauseMenuItem = null;
    private JMenuItem m_setPlaybackRateMenuItem = null;
    private JMenu m_viewMenu = null;
    private JMenuItem m_viewSelectedMapMenuItem = null;
    private JCheckBoxMenuItem m_viewStatisticsItem = null;
    private JCheckBoxMenuItem m_viewWorkflowTreeItem = null;
    private JMenu m_simulationMenu = null;
    private JMenuItem m_stopSimulationMenuItem = null;
    private JMenu m_helpMenu = null;
    private JMenuItem m_contentsIndexItem = null;
    private JMenuItem m_aboutItem = null;
    private JPanel m_statusBar = null;
    private JLabel m_msgLabel = null;
    private JCheckBox m_stepNamesCheckBox = null;
    private JCheckBox m_routeNamesCheckBox = null;
    private JCheckBox m_milestoneAttrsCheckBox = null;
    private JCheckBox m_conditionAttrsCheckBox = null;
    private JCheckBox m_collectorAttrsCheckBox = null;
    private JCheckBox m_stepStatusCheckBox = null;
    private Container m_mainContainer = null;
    private Container m_contentPane = null;
    private JRootPane m_rootPane = null;
    private Frame m_parentFrame = null;
    private JApplet m_applet = null;
    private boolean m_bFrame = false;
    private JPanel m_mainPanel = new JPanel();
    private VWToolbarActionNotifier m_toolbarActionNotifier = null;
    private JPanel m_toolbarPanel = new JPanel();
    private JToolBar m_animationToolBar = new JToolBar();
    private AbstractButton m_startBtn = null;
    private AbstractButton m_pauseBtn = null;
    private AbstractButton m_stopBtn = null;
    private JToolBar m_viewToolBar = new JToolBar();
    private AbstractButton m_viewSelectedMapBtn = null;
    private JToolBar m_helpToolBar = new JToolBar();
    private AbstractButton m_contextAndIndexBtn = null;
    private JPanel m_mapInfoPanel = new JPanel();
    private JLabel m_workflowAndMapUI = new JLabel();
    private int m_workflowAndMapUILength = 0;
    private JLabel m_animationTimeUI = new JLabel();
    private String m_currentWorkflow = null;
    private String m_currentMap = null;
    private JMenuBar m_menuBar = new JMenuBar();
    private ItemListener m_viewStatisticsListener = null;
    private ItemListener m_viewTreeInfoListener = null;
    private boolean m_bInitialized = false;
    private Object m_sync = null;
    private static final double s_defaultHSplitRatio = 0.33;
    private static final double s_defaultHSplitRatio_bidi = 0.7;
    private static final double s_defaultVSplitRatio = 0.66;
    private double m_hSplitRatio = 0.0;
    private int m_vLastLoc = 0;
    private int m_hLastLoc = 0;

    void setSplashWindow(VWSplashWindow splashWindow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.m_mainContainer = sessionInfo.getParentContainer();
        if (this.m_mainContainer instanceof JFrame) {
            this.m_bFrame = true;
        } else {
            this.m_bFrame = false;
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JApplet) {
                this.m_applet = (JApplet)this.m_mainContainer;
            }
        }
        try {
            Locale browserLocale = sessionInfo.getBrowserLocale();
            if (browserLocale != null) {
                sessionInfo.getSession().setClientLocale(browserLocale);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this.m_mainContainer);
        if (repaintManager != null && !repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_mainContainer);
        VWDefaultSessionProxy.setSession(sessionInfo.getSession());
        super.init(sessionInfo);
        try {
            VWSIMSession simSession = null;
            String scenarioDefFile = sessionInfo.getProperty("scenariodef");
            String eventbufferFile = sessionInfo.getProperty("eventbuf");
            if (scenarioDefFile != null && scenarioDefFile.length() > 0 && eventbufferFile != null && eventbufferFile.length() > 0) {
                this.m_animationDP = VWSIMAnimationDP.loadFromFiles(scenarioDefFile, eventbufferFile);
                if (this.m_animationDP == null) {
                    throw new Exception(VWSIMResource.s_failedToRetrieveAnimationDataProvider);
                }
                if (this.m_animationController != null) {
                    this.m_animationController.setSimulation(this.m_animationDP);
                }
                this.m_animatorDataModel = new VWSIMAnimatorDataModel((Container)this.m_parentFrame, this.m_animationDP);
            } else {
                IVWSIMSimulation simulation = null;
                simSession = new VWSIMSession();
                if (simSession != null) {
                    String library = sessionInfo.getProperty("library");
                    String docId = sessionInfo.getProperty("docId");
                    if (library != null && docId != null) {
                        simulation = simSession.getSimulation(library, docId);
                    }
                } else {
                    throw new Exception(VWSIMResource.s_failedToRetrieveSimSession);
                }
                if (simulation == null || simulation.getAnimationDataProvider() == null) {
                    throw new Exception(VWSIMResource.s_failedToRetrieveAnimationDataProvider);
                }
                if (this.m_animationController != null) {
                    this.m_animationController.setSimulation(simulation);
                }
                this.m_animatorDataModel = new VWSIMAnimatorDataModel((Container)this.m_parentFrame, simulation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex, VWSIMResource.s_failedToInitializeData);
            try {
                this.failedInitData(ex);
            }
            catch (Exception ex1) {
                VWDebug.logException(ex);
                return;
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.m_toolbarActionNotifier = new VWToolbarActionNotifier();
        this.m_toolbarActionNotifier.addToolbarActionListener(this);
        if (this.m_mainContainer instanceof JFrame) {
            this.m_bFrame = true;
            this.m_contentPane = ((JFrame)this.m_mainContainer).getContentPane();
            this.m_rootPane = ((JFrame)this.m_mainContainer).getRootPane();
        } else {
            this.m_bFrame = false;
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JApplet) {
                this.m_applet = (JApplet)this.m_mainContainer;
                this.m_contentPane = this.m_applet.getContentPane();
                this.m_rootPane = this.m_applet.getRootPane();
            }
        }
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_contentPane.add((Component)this.m_mainPanel, "Center");
        this.m_sync = new Object();
        if (this.m_animatorDataModel != null) {
            this.m_initRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean bInitialized = false;
                    Object object = VWSIMAnimatorCore.this.m_sync;
                    synchronized (object) {
                        int state = VWSIMAnimatorCore.this.m_animatorDataModel.getInitState();
                        while (!bInitialized || state != 6 && state != 7) {
                            state = VWSIMAnimatorCore.this.m_animatorDataModel.getInitState();
                            if (state <= 2 || bInitialized) continue;
                            bInitialized = true;
                            VWSIMAnimatorCore.this.initApplicationPane();
                            VWSIMAnimatorCore.this.initListeners();
                            VWSIMAnimatorCore.this.initMenuBar(VWSIMAnimatorCore.this.m_menuBar);
                            VWSIMAnimatorCore.this.m_rootPane.setJMenuBar(VWSIMAnimatorCore.this.m_menuBar);
                            VWSIMAnimatorCore.this.initToolBars();
                            VWSIMAnimatorCore.this.initStatusBar();
                            VWSIMAnimatorCore.this.m_contentPane.add("First", VWSIMAnimatorCore.this.m_toolbarPanel);
                            VWSIMAnimatorCore.this.m_mainContainer.invalidate();
                            VWSIMAnimatorCore.this.m_mainContainer.validate();
                            VWSIMAnimatorCore.this.m_mainContainer.repaint();
                        }
                        if (state == 6) {
                            VWSIMAnimatorCore.this.initData();
                        }
                        VWSIMAnimatorCore.this.m_sync.notifyAll();
                    }
                }
            };
            this.m_initThread = new Thread(this.m_initRunnable, "VWSIMAnimatorCoreThread");
            this.m_initThread.start();
        }
        int initState = 0;
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            Object ex = this.m_sync;
            synchronized (ex) {
                initState = this.m_animatorDataModel != null ? this.m_animatorDataModel.getInitState() : 7;
            }
        } while (initState != 6 && initState != 7);
        if (initState == 7) {
            try {
                this.failedInitData();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                return;
            }
        }
        if (initState == 6) {
            if (this.m_bInitialized) {
                return;
            }
            Object object = this.m_sync;
            synchronized (object) {
                this.initApplicationState();
                this.initToolbarStatus();
                this.m_bInitialized = true;
                if (this.m_rootSplitPane != null) {
                    this.m_rootSplitPane.setInitialized(true);
                }
                if (this.m_viewSplitPane != null) {
                    this.m_viewSplitPane.setInitialized(true);
                }
            }
        }
        super.performInitialRefresh();
        this.startAnimationThreads();
    }

    private void failedInitData(Exception ex) throws Exception {
        if (ex != null) {
            this.failedInitData(ex.getLocalizedMessage());
        } else {
            this.failedInitData();
        }
    }

    private void failedInitData() throws Exception {
        this.failedInitData("");
    }

    private void failedInitData(String errorString) throws Exception {
        String str = VWSIMResource.s_failedToInitializeData;
        if (errorString != null) {
            str = str + "\n" + errorString;
        }
        VWMessageDialog.showOptionDialog(this.m_parentFrame, str, this.getProductName(), 1);
        throw new Exception(str);
    }

    private void initToolbarStatus() {
        if (this.m_bInitialized) {
            return;
        }
        this.m_statusBar.addMouseListener(this);
        this.initViewMenu();
    }

    private void initViewMenu() {
        this.m_viewMenu.addMenuListener(this);
        this.m_viewMenu.add(new JSeparator());
        this.m_viewWorkflowTreeItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWSIMResource.s_viewWorkflowTreeMenuItem_withHK);
        this.m_viewWorkflowTreeItem.addItemListener(this);
        this.m_viewWorkflowTreeItem.addItemListener(this.m_viewTreeInfoListener);
        this.m_viewWorkflowTreeItem.setSelected(true);
        this.m_viewMenu.add(this.m_viewWorkflowTreeItem);
        this.m_viewStatisticsItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWSIMResource.s_viewStatisticsMenuItem_withHK);
        this.m_viewStatisticsItem.addItemListener(this.m_viewStatisticsListener);
        this.m_viewStatisticsItem.setSelected(true);
        this.m_viewMenu.add(this.m_viewStatisticsItem);
    }

    boolean isInitialized() {
        return this.m_bInitialized;
    }

    private void initApplicationPane() {
        this.m_rootSplitPane = new RootSplitPane(this);
        this.m_viewSplitPane = new ViewSplitPane(this);
        Dimension dim = this.m_mainContainer.getSize();
        int nWidth = dim.width * 2 / 3;
        int nHeight = dim.height * 4 / 7;
        this.m_animatorWorkflowPane = new VWSIMAnimatorWorkflowPane(this.m_parentFrame, this.m_animatorDataModel, this.m_sessionInfo);
        this.m_animatorWorkflowPane.init(this.m_toolbarActionNotifier);
        this.m_mapTreePane = new VWSIMAnimatorTreePane(this.m_parentFrame, this.m_animatorDataModel);
        this.m_mapTreePane.addItemListener(this);
        this.m_mapTreePane.addItemListener(this.m_animatorWorkflowPane);
        this.m_statisticsPane = new VWSIMStatisticsPanel(this.m_parentFrame, this.m_animationController, this.m_animatorDataModel);
        this.m_mainPanel.setLayout(new BorderLayout());
        this.m_mainPanel.add((Component)this.m_rootSplitPane, "Center");
        this.m_rootSplitPane.setOrientation(0);
        this.m_rootSplitPane.setPreferredSize(new Dimension(nWidth, nHeight));
        this.m_rootSplitPane.setOneTouchExpandable(true);
        this.m_viewSplitPane.setOneTouchExpandable(true);
        this.m_viewSplitPane.setOrientation(1);
        this.m_viewSplitPane.setToolTipText(VWSIMResource.s_slideToAdjustView);
        Locale browserLocale = this.m_sessionInfo.getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
        if (compOrientation.isLeftToRight()) {
            this.m_hSplitRatio = 0.33;
            this.m_viewSplitPane.setLeftComponent(this.m_mapTreePane);
            this.m_viewSplitPane.setRightComponent(this.m_animatorWorkflowPane);
        } else {
            this.m_hSplitRatio = 0.7;
            this.m_viewSplitPane.setLeftComponent(this.m_animatorWorkflowPane);
            this.m_viewSplitPane.setRightComponent(this.m_mapTreePane);
        }
        this.m_rootSplitPane.setBottomComponent(this.m_statisticsPane);
        this.m_rootSplitPane.setTopComponent(this.m_viewSplitPane);
    }

    private void initData() {
        VWSIMAnimatorMap map;
        if (this.m_animatorDataModel == null || this.m_animatorDataModel.getInitState() != 6) {
            return;
        }
        if (this.m_statisticsPane != null) {
            this.m_statisticsPane.initialize();
            if (this.m_mapTreePane != null) {
                this.m_statisticsPane.addItemListener(this.m_mapTreePane);
            }
        }
        if (this.m_animatorWorkflowPane != null) {
            this.m_animatorWorkflowPane.initialize();
            if (this.m_mapTreePane != null) {
                this.m_animatorWorkflowPane.addItemListener(this.m_mapTreePane);
            }
        }
        if (this.m_animatorDataModel != null && (map = this.m_animatorDataModel.getSelectedMap()) != null) {
            this.updateCurrentMapNameUI(map);
        }
    }

    private void initApplicationState() {
        this.m_rootSplitPane.setDividerLocation(0.66);
        this.m_rootSplitPane.setLastDividerLocation(this.m_rootSplitPane.getDividerLocation());
        this.m_viewSplitPane.setDividerLocation(this.m_hSplitRatio);
        this.m_viewSplitPane.setLastDividerLocation(this.m_viewSplitPane.getDividerLocation());
        if (this.m_viewStatisticsItem != null) {
            this.m_viewStatisticsItem.setSelected(true);
        }
        if (this.m_viewWorkflowTreeItem != null) {
            this.m_viewWorkflowTreeItem.setSelected(true);
        }
    }

    private boolean isStatisticsPaneShown() {
        if (this.m_rootSplitPane == null) {
            return false;
        }
        int location = this.m_rootSplitPane.getDividerLocation();
        int totalSize = this.m_rootSplitPane.getHeight() - this.m_rootSplitPane.getDividerSize();
        int diff = totalSize - location;
        return diff > 2;
    }

    protected void updateStatisticsPaneViewStatus() {
        if (this.m_rootSplitPane == null) {
            return;
        }
        boolean bShown = this.isStatisticsPaneShown();
        if (this.m_viewStatisticsItem != null) {
            this.m_viewStatisticsItem.setSelected(bShown);
        }
    }

    private boolean isViewPaneShown() {
        if (this.m_rootSplitPane == null) {
            return true;
        }
        int location = this.m_rootSplitPane.getDividerLocation();
        return location > 2;
    }

    private boolean isWorkflowTreePaneShown() {
        if (this.m_viewSplitPane == null) {
            return false;
        }
        if (this.isViewPaneShown()) {
            int location = this.m_viewSplitPane.getDividerLocation();
            return location > 2;
        }
        return false;
    }

    protected void updateWorkflowTreePaneViewStatus() {
        boolean bShown = this.isWorkflowTreePaneShown();
        if (this.m_viewWorkflowTreeItem != null) {
            this.m_viewWorkflowTreeItem.setSelected(bShown);
        }
    }

    private void initListeners() {
        this.m_viewStatisticsListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWSIMAnimatorCore.this.performViewStatistics(e.getStateChange() == 1);
            }
        };
        this.m_viewTreeInfoListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VWSIMAnimatorCore.this.performViewWorkflowTree(e.getStateChange() == 1);
            }
        };
    }

    private void initMenuBar(JMenuBar menuBar) {
        if (this.m_bFrame) {
            this.m_fileMenu = VWStringUtils.getMenuUsingString(VWSIMResource.s_fileMenu_withHK);
            menuBar.add(this.m_fileMenu);
            this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_exitMenu_withHK);
            this.m_exitItem.addActionListener(this);
            this.m_fileMenu.add(this.m_exitItem);
        }
        this.m_viewMenu = VWStringUtils.getMenuUsingString(VWSIMResource.s_viewMenu_withHK);
        menuBar.add(this.m_viewMenu);
        this.m_viewSelectedMapMenuItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_viewSelectedMapMenuItem_withHK);
        this.m_viewSelectedMapMenuItem.addActionListener(this);
        this.m_viewMenu.add(this.m_viewSelectedMapMenuItem);
        this.m_animationMenu = VWStringUtils.getMenuUsingString(VWSIMResource.s_animationMenu_withHK);
        this.m_animationMenu.addMenuListener(this);
        menuBar.add(this.m_animationMenu);
        this.m_startMenuItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_startMenuItem_withHK);
        this.m_startMenuItem.addActionListener(this);
        this.m_animationMenu.add(this.m_startMenuItem);
        this.m_pauseMenuItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_pauseMenuItem_withHK);
        this.m_pauseMenuItem.addActionListener(this);
        this.m_animationMenu.add(this.m_pauseMenuItem);
        this.m_stopMenuItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_stopMenuItem_withHK);
        this.m_stopMenuItem.addActionListener(this);
        this.m_animationMenu.add(this.m_stopMenuItem);
        this.m_animationMenu.add(new JSeparator());
        this.m_setPlaybackRateMenuItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_setPlaybackRateMenuItem_withHK);
        this.m_setPlaybackRateMenuItem.addActionListener(this);
        this.m_animationMenu.add(this.m_setPlaybackRateMenuItem);
        this.m_simulationMenu = VWStringUtils.getMenuUsingString(VWSIMResource.s_simulationMenu_withHK);
        this.m_simulationMenu.addMenuListener(this);
        menuBar.add(this.m_simulationMenu);
        this.m_stopSimulationMenuItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_stopSimulationMenuItem);
        this.m_stopSimulationMenuItem.addActionListener(this);
        this.m_simulationMenu.add(this.m_stopSimulationMenuItem);
        JMenu settingsMenu = this.getSettingsMenu(this.m_menuBar);
        if (settingsMenu != null) {
            this.m_menuBar.add(settingsMenu);
        }
        this.m_helpMenu = VWStringUtils.getMenuUsingString(VWSIMResource.s_helpMenu_withHK);
        menuBar.add(this.m_helpMenu);
        this.m_contentsIndexItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_ellipse.toString(VWSIMResource.s_contentsAndIndexMenuItem));
        this.m_contentsIndexItem.addActionListener(this);
        this.m_helpMenu.add(this.m_contentsIndexItem);
        this.m_helpMenu.add(new JSeparator());
        this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.s_ellipse.toString(VWSIMResource.s_about_withHK));
        this.m_aboutItem.addActionListener(this);
        this.m_helpMenu.add(this.m_aboutItem);
    }

    private void initPlayToolBar(JToolBar toolbar) {
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_startBtn = this.addToolBarButton(toolbar, "start", VWSIMResource.s_startButtonTooltip, false, this);
        this.m_startBtn.setEnabled(true);
        this.m_pauseBtn = this.addToolBarButton(toolbar, "pause", VWSIMResource.s_pauseButtonTooltip, false, this);
        this.m_pauseBtn.setEnabled(false);
        this.m_stopBtn = this.addToolBarButton(toolbar, "stop", VWSIMResource.s_stopButtonTooltip, false, this);
        this.m_stopBtn.setEnabled(false);
    }

    private void initViewToolBar(JToolBar toolbar) {
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_viewSelectedMapBtn = this.addToolBarButton(toolbar, "map_select", VWSIMResource.s_displaySelectedMap, false, this);
    }

    private void initHelpToolBar(JToolBar toolbar) {
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        this.m_contextAndIndexBtn = this.addToolBarButton(toolbar, "help", VWSIMResource.s_help, false, this);
    }

    private void initMapInfoPanel(JPanel panel) {
        this.m_workflowAndMapUI.setHorizontalAlignment(4);
        if (this.m_currentWorkflow == null || this.m_currentMap == null) {
            this.m_workflowAndMapUI.setText(null);
        } else {
            this.m_workflowAndMapUI.setText(VWSIMResource.s_workflowAndMap.toString(this.m_currentWorkflow, this.m_currentMap));
        }
        this.m_animationTimeUI.setText(null);
        JPanel mapNamePanel = new JPanel(new BorderLayout());
        mapNamePanel.add((Component)this.m_workflowAndMapUI, "After");
        JPanel timePanel = new JPanel(new BorderLayout());
        timePanel.add((Component)this.m_animationTimeUI, "After");
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        panel.add(mapNamePanel);
        panel.add(timePanel);
    }

    private void initToolBars() {
        this.initPlayToolBar(this.m_animationToolBar);
        this.initHelpToolBar(this.m_helpToolBar);
        this.initViewToolBar(this.m_viewToolBar);
        this.initMapInfoPanel(this.m_mapInfoPanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setAlignmentX(0.0f);
        panel.add(this.m_animationToolBar);
        VWSIMImageLoader.addToolbarSeparator(this.m_animationToolBar);
        panel.add(this.m_viewToolBar);
        VWSIMImageLoader.addToolbarSeparator(this.m_viewToolBar);
        panel.add(this.m_helpToolBar);
        this.m_toolbarPanel.setLayout(new BorderLayout());
        this.m_toolbarPanel.add((Component)panel, "Before");
        this.m_toolbarPanel.add((Component)this.m_mapInfoPanel, "After");
    }

    private AbstractButton addToolBarButton(JToolBar toolbar, String name, String toolTip, boolean bUseToggleButton, EventListener listener) {
        AbstractButton button = VWSIMImageLoader.createToolBarButton(name + ".gif", toolTip, bUseToggleButton);
        if (button != null) {
            toolbar.add(button);
            button.setRolloverEnabled(true);
            if (listener instanceof ActionListener) {
                button.addActionListener((ActionListener)listener);
            } else if (listener instanceof ItemListener) {
                button.addItemListener((ItemListener)listener);
            }
        }
        return button;
    }

    private void initStatusBar() {
        try {
            this.m_statusBar = new JPanel();
            this.m_statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_statusBar.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_msgLabel = new JLabel();
            this.m_statusBar.add((Component)this.m_msgLabel, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_stepNamesCheckBox = new JCheckBox(VWSIMImageLoader.createImageIcon("step_hide.gif"));
            this.m_stepNamesCheckBox.setSelectedIcon(VWSIMImageLoader.createImageIcon("step_show.gif"));
            this.m_stepNamesCheckBox.setToolTipText(VWSIMResource.s_showHideStepNamesStr);
            this.m_stepNamesCheckBox.setSelected(true);
            this.m_stepNamesCheckBox.addItemListener(this);
            this.m_statusBar.add((Component)this.m_stepNamesCheckBox, gbCons);
            ++gbCons.gridx;
            this.m_routeNamesCheckBox = new JCheckBox(VWSIMImageLoader.createImageIcon("route_hide.gif"));
            this.m_routeNamesCheckBox.setSelectedIcon(VWSIMImageLoader.createImageIcon("route_show.gif"));
            this.m_routeNamesCheckBox.setToolTipText(VWSIMResource.s_showHideRouteNamesStr);
            this.m_routeNamesCheckBox.setSelected(true);
            this.m_routeNamesCheckBox.addItemListener(this);
            this.m_statusBar.add((Component)this.m_routeNamesCheckBox, gbCons);
            ++gbCons.gridx;
            this.m_milestoneAttrsCheckBox = new JCheckBox(VWSIMImageLoader.createImageIcon("milestone_hide.gif"));
            this.m_milestoneAttrsCheckBox.setSelectedIcon(VWSIMImageLoader.createImageIcon("milestone_show.gif"));
            this.m_milestoneAttrsCheckBox.setToolTipText(VWSIMResource.s_showHideMilestoneAttributesStr);
            this.m_milestoneAttrsCheckBox.setSelected(true);
            this.m_milestoneAttrsCheckBox.addItemListener(this);
            this.m_statusBar.add((Component)this.m_milestoneAttrsCheckBox, gbCons);
            ++gbCons.gridx;
            this.m_conditionAttrsCheckBox = new JCheckBox(VWSIMImageLoader.createImageIcon("condition_hide.gif"));
            this.m_conditionAttrsCheckBox.setSelectedIcon(VWSIMImageLoader.createImageIcon("condition_show.gif"));
            this.m_conditionAttrsCheckBox.setToolTipText(VWSIMResource.s_showHideConditionAttributesStr);
            this.m_conditionAttrsCheckBox.setSelected(true);
            this.m_conditionAttrsCheckBox.addItemListener(this);
            this.m_statusBar.add((Component)this.m_conditionAttrsCheckBox, gbCons);
            ++gbCons.gridx;
            this.m_collectorAttrsCheckBox = new JCheckBox(VWSIMImageLoader.createImageIcon("collector_hide.gif"));
            this.m_collectorAttrsCheckBox.setSelectedIcon(VWSIMImageLoader.createImageIcon("collector_show.gif"));
            this.m_collectorAttrsCheckBox.setToolTipText(VWSIMResource.s_showHideCollectorAttributesStr);
            this.m_collectorAttrsCheckBox.setSelected(true);
            this.m_collectorAttrsCheckBox.addItemListener(this);
            this.m_statusBar.add((Component)this.m_collectorAttrsCheckBox, gbCons);
            ++gbCons.gridx;
            this.m_stepStatusCheckBox = new JCheckBox(VWSIMImageLoader.createImageIcon("status_hide.gif"));
            this.m_stepStatusCheckBox.setSelectedIcon(VWSIMImageLoader.createImageIcon("status_show.gif"));
            this.m_stepStatusCheckBox.setToolTipText(VWSIMResource.s_showHideStepStatusStr);
            this.m_stepStatusCheckBox.setSelected(true);
            this.m_stepStatusCheckBox.addItemListener(this);
            this.m_statusBar.add((Component)this.m_stepStatusCheckBox, gbCons);
            this.m_contentPane.add((Component)this.m_statusBar, "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 4) {
            this.saveScenarioAndEventBufToFiles();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exitApplication();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private void updateCurrentMapNameUI(VWSIMAnimatorMap map) {
        int length;
        FontMetrics fm;
        Font font;
        boolean bCallUpdateUI = false;
        this.m_currentWorkflow = map.getWorkflowName();
        this.m_currentMap = map.getMapName();
        String str = VWSIMResource.s_workflowAndMap.toString(this.m_currentWorkflow, this.m_currentMap);
        if (str != null && (font = this.m_workflowAndMapUI.getFont()) != null && (fm = this.m_workflowAndMapUI.getFontMetrics(font)) != null && (length = fm.stringWidth(str)) > this.m_workflowAndMapUILength) {
            bCallUpdateUI = true;
            this.m_workflowAndMapUILength = length;
        }
        this.m_workflowAndMapUI.setText(str);
        if (bCallUpdateUI) {
            this.m_mapInfoPanel.updateUI();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object obj = event.getItem();
        if (obj == null) {
            return;
        }
        if (event.getStateChange() == 1 && obj instanceof VWSIMAnimatorMap) {
            VWSIMAnimatorMap map = (VWSIMAnimatorMap)obj;
            this.updateCurrentMapNameUI(map);
        } else if (obj == this.m_stepNamesCheckBox) {
            this.performViewStepNames(event.getStateChange() == 1);
        } else if (obj == this.m_routeNamesCheckBox) {
            this.performViewRouteNames(event.getStateChange() == 1);
        } else if (obj == this.m_stepStatusCheckBox) {
            this.performViewStepStatus(event.getStateChange() == 1);
        } else if (obj == this.m_milestoneAttrsCheckBox) {
            this.performViewMilestoneAttrs(event.getStateChange() == 1);
        } else if (obj == this.m_conditionAttrsCheckBox) {
            this.performViewConditionAttrs(event.getStateChange() == 1);
        } else if (obj == this.m_collectorAttrsCheckBox) {
            this.performViewCollectorAttrs(event.getStateChange() == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performPlayAnimation() {
        if (this.m_animationController != null) {
            if (this.m_animationController.getPlayMode() != 2) {
                this.m_animationController.setPlayMode(2);
            }
            if (this.m_startBtn != null) {
                this.m_startBtn.setEnabled(false);
            }
            if (this.m_pauseBtn != null) {
                this.m_pauseBtn.setEnabled(true);
            }
            if (this.m_stopBtn != null) {
                this.m_stopBtn.setEnabled(true);
            }
            Object object = this.m_updateObject;
            synchronized (object) {
                this.m_bNeedUpdate = true;
                this.m_progress = 1;
            }
        }
    }

    protected void performSetPlaybackRate() {
        VWSIMAnimatorSetPlaybackRateDialog dialog;
        if (this.m_animationController != null && (dialog = new VWSIMAnimatorSetPlaybackRateDialog(this.m_parentFrame, this.m_animationController.getPlaybackRate())) != null) {
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                int playbackRate = dialog.getPlaybackRate();
                this.m_animationController.setPlaybackRate(playbackRate);
            }
            dialog.releaseResources();
            dialog.dispose();
            Object var1_1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performPauseAnimation() {
        if (this.m_animationController != null) {
            int playMode = this.m_animationController.getPlayMode();
            if (playMode == 1) {
                this.m_animationController.setPlayMode(2);
            } else if (playMode == 2) {
                this.m_animationController.setPlayMode(1);
            }
            if (this.m_startBtn != null) {
                this.m_startBtn.setEnabled(true);
            }
            if (this.m_pauseBtn != null) {
                this.m_pauseBtn.setEnabled(false);
            }
            if (this.m_stopBtn != null) {
                this.m_stopBtn.setEnabled(true);
            }
            Object object = this.m_updateObject;
            synchronized (object) {
                this.m_bNeedUpdate = true;
                this.m_progress = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performStopAnimation() {
        if (this.m_animationController != null) {
            if (this.m_animationController.getPlayMode() != 0) {
                this.m_animationController.setPlayMode(0);
            }
            if (this.m_startBtn != null) {
                this.m_startBtn.setEnabled(true);
            }
            if (this.m_pauseBtn != null) {
                this.m_pauseBtn.setEnabled(false);
            }
            if (this.m_stopBtn != null) {
                this.m_stopBtn.setEnabled(false);
            }
            Object object = this.m_updateObject;
            synchronized (object) {
                if (this.m_progress != 4) {
                    this.m_bNeedUpdate = true;
                    this.m_progress = 3;
                }
            }
        }
    }

    protected void performViewSelecedMap() {
        if (this.m_mapTreePane != null) {
            this.m_mapTreePane.notifySelectListeners();
        }
    }

    protected void performExitItemAction() {
        String save = this.m_sessionInfo.getProperty("enablesave");
        if (save != null && VWStringUtils.compare(save, "true") == 0) {
            this.saveScenarioAndEventBufToFiles();
        }
        this.exitApplication();
    }

    private void saveScenarioAndEventBufToFiles() {
        if (this.m_animationController == null || this.m_animationController.getPlaybackRate() != 9999 || this.m_animationController.getPlayMode() != 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Save scenario and event buffer to files?", "Save", 1);
        switch (result) {
            case 1: {
                break;
            }
            case 0: {
                FileDialog fileDialog = new FileDialog(this.m_parentFrame, "Scenario file", 1);
                fileDialog.setVisible(true);
                String eventFile = null;
                String scenarioFile = fileDialog.getFile();
                String dir = fileDialog.getDirectory();
                if (dir != null && scenarioFile != null) {
                    scenarioFile = dir + scenarioFile;
                }
                fileDialog = new FileDialog(this.m_parentFrame, "Event buffer file", 1);
                fileDialog.setDirectory(dir);
                fileDialog.setVisible(true);
                eventFile = fileDialog.getFile();
                dir = fileDialog.getDirectory();
                if (dir != null && eventFile != null) {
                    eventFile = dir + eventFile;
                }
                if (scenarioFile == null && eventFile == null || this.m_animationController == null) break;
                this.m_animationController.writeToFiles(scenarioFile, eventFile);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void performViewStatistics(boolean bView) {
        boolean bChanged = false;
        if (bView) {
            if (!this.isStatisticsPaneShown()) {
                if (this.m_vLastLoc > this.m_rootSplitPane.getMaximumDividerLocation()) {
                    this.m_vLastLoc = this.m_rootSplitPane.getMaximumDividerLocation();
                }
                this.m_rootSplitPane.setDividerLocation(this.m_vLastLoc);
                bChanged = true;
            }
        } else if (this.isStatisticsPaneShown()) {
            this.m_vLastLoc = this.m_rootSplitPane.getDividerLocation();
            this.m_rootSplitPane.setDividerLocation(1.0);
            bChanged = true;
        }
        if (bChanged) {
            boolean bShown = this.isStatisticsPaneShown();
            if (this.m_viewStatisticsItem != null) {
                this.m_viewStatisticsItem.setSelected(bShown);
            }
        }
    }

    protected void performViewWorkflowTree(boolean bView) {
        boolean bChanged = false;
        if (bView) {
            if (!this.isWorkflowTreePaneShown()) {
                if (!this.isViewPaneShown()) {
                    if (this.m_vLastLoc < this.m_rootSplitPane.getMinimumDividerLocation()) {
                        this.m_vLastLoc = this.m_rootSplitPane.getMinimumDividerLocation();
                    }
                    this.m_rootSplitPane.setDividerLocation(this.m_vLastLoc);
                    bChanged = true;
                }
                if (!this.isWorkflowTreePaneShown()) {
                    if (this.m_hLastLoc < this.m_viewSplitPane.getMinimumDividerLocation()) {
                        this.m_hLastLoc = this.m_viewSplitPane.getMinimumDividerLocation();
                    }
                    this.m_viewSplitPane.setDividerLocation(this.m_hLastLoc);
                    bChanged = true;
                }
            }
        } else if (this.isWorkflowTreePaneShown()) {
            this.m_hLastLoc = this.m_viewSplitPane.getDividerLocation();
            this.m_viewSplitPane.setDividerLocation(0.0);
            bChanged = true;
        }
        if (bChanged) {
            boolean bShown = this.isWorkflowTreePaneShown();
            if (this.m_viewWorkflowTreeItem != null) {
                this.m_viewWorkflowTreeItem.setSelected(bShown);
            }
        }
    }

    protected void performViewStepNames(boolean bView) {
        this.m_animatorWorkflowPane.getMapAttributes().setStepNameVisible(bView);
    }

    protected void performViewRouteNames(boolean bView) {
        this.m_animatorWorkflowPane.getMapAttributes().setRouteNameVisible(bView);
    }

    protected void performViewStepStatus(boolean bView) {
        this.m_animatorWorkflowPane.setStepStatusVisible(bView);
    }

    private void performMainToolbarAction(boolean bShow, boolean bNotify) {
    }

    private void performViewMilestoneAttrs(boolean bShow) {
        this.m_animatorWorkflowPane.getMapAttributes().setMilestoneVisible(bShow);
    }

    private void performViewConditionAttrs(boolean bShow) {
        this.m_animatorWorkflowPane.getMapAttributes().setConditionAttrsVisible(bShow);
    }

    private void performViewCollectorAttrs(boolean bShow) {
        this.m_animatorWorkflowPane.getMapAttributes().setCollectorAttrsVisible(bShow);
    }

    private void performStatusBarAction(boolean bShow, boolean bNotify) {
    }

    protected void performStopSimulation() {
        if (this.m_animatorDataModel != null) {
            this.m_animatorDataModel.stopSimulation();
        }
    }

    protected void performContentsAndIndex() {
        VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Animator + "_start_here_animator.htm");
    }

    protected void performAboutItemAction() {
        try {
            ImageIcon icon = VWSIMImageLoader.createImageIcon("animator.gif");
            String productName = this.getProductName();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_parentFrame, productName, icon, this.m_sessionInfo);
            aboutBox.display();
            aboutBox.removeAll();
            Object var3_4 = null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    void exitApplication() {
        if (this.m_mainContainer != null && this.m_bFrame) {
            JFrame frame = (JFrame)this.m_mainContainer;
            if (this.doExit()) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(frame, 201));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doExit() {
        boolean bReturn = true;
        try {
            if (this.m_animationController != null && (this.m_animationController.getPlayMode() == 2 || this.m_animationController.getPlayMode() == 1)) {
                int mode = this.m_animationController.getPlayMode();
                this.m_animationController.setPlayMode(1);
                int result = JOptionPane.showConfirmDialog(null, VWSIMResource.s_doYouWantToStopAnimation, VWSIMResource.s_animationStillActive, 2);
                if (result == 0) {
                    this.m_animationController.setPlayMode(0);
                } else if (result == 2) {
                    this.m_animationController.setPlayMode(mode);
                    bReturn = false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            if (bReturn) {
                this.m_bExit = true;
                this.cleanup();
            }
        }
        return bReturn;
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        if (event.getSource() == this) {
            return;
        }
        switch (event.getID()) {
            case 600: {
                this.performMainToolbarAction(true, false);
                break;
            }
            case 601: {
                this.performMainToolbarAction(false, false);
                break;
            }
            case 604: {
                this.performStatusBarAction(true, false);
                break;
            }
            case 605: {
                this.performStatusBarAction(false, false);
            }
        }
    }

    public Frame getParentFrame() {
        return this.m_parentFrame;
    }

    String getSimulationName() {
        if (this.m_animatorDataModel != null) {
            return this.m_animatorDataModel.getSimulationName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupThreads() {
        if (this.m_initThread != null) {
            try {
                this.m_initThread.join(1000L);
            }
            catch (InterruptedException ex) {
                VWDebug.logException(ex);
            }
            finally {
                this.m_initThread = null;
            }
        }
        if (this.m_animationController != null) {
            this.m_animationController.done();
        }
        if (this.m_animateThread != null) {
            for (int i = 0; i < this.m_animateThread.length; ++i) {
                if (this.m_animateThread[i] == null) continue;
                try {
                    this.m_animateThread[i].join(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    VWDebug.logException(ex);
                    continue;
                }
                finally {
                    this.m_animateThread[i] = null;
                }
            }
            this.m_animateThread = null;
        }
        if (this.m_statisticsPane != null) {
            this.m_statisticsPane.done();
        }
        if (this.m_statPanelUpdateThread != null) {
            try {
                this.m_statPanelUpdateThread.join(1000L);
            }
            catch (InterruptedException ex) {
                VWDebug.logException(ex);
            }
            finally {
                this.m_statPanelUpdateThread = null;
            }
        }
        if (this.m_timeUpdateThread != null) {
            try {
                this.m_timeUpdateThread.join(1000L);
            }
            catch (InterruptedException ex) {
                VWDebug.logException(ex);
            }
            finally {
                this.m_timeUpdateThread = null;
            }
        }
    }

    private void cleanup() {
        this.cleanupThreads();
        if (this.m_toolbarActionNotifier != null) {
            this.m_toolbarActionNotifier.removeToolbarActionListener(this);
            this.m_toolbarActionNotifier = null;
        }
        if (this.m_viewSplitPane != null) {
            this.m_viewSplitPane.setToolTipText(null);
            this.m_viewSplitPane.setLeftComponent(null);
            this.m_viewSplitPane.setRightComponent(null);
            this.m_viewSplitPane.releaseResources();
        }
        if (this.m_rootSplitPane != null) {
            this.m_rootSplitPane.setBottomComponent(null);
            this.m_rootSplitPane.setTopComponent(null);
            this.m_rootSplitPane.releaseResources();
        }
        if (this.m_mapTreePane != null) {
            this.m_mapTreePane.removeItemListener(this);
            this.m_mapTreePane.removeItemListener(this.m_animatorWorkflowPane);
        }
        if (this.m_statisticsPane != null) {
            this.m_statisticsPane.removeItemListener(this.m_mapTreePane);
            this.m_animationController.removeAnimationUpdateListener(this.m_statisticsPane);
        }
        if (this.m_mapTreePane != null) {
            this.m_mapTreePane.releaseResources();
        }
        if (this.m_statisticsPane != null) {
            this.m_statisticsPane.releaseResources();
        }
        if (this.m_animatorWorkflowPane != null) {
            this.m_animatorWorkflowPane.releaseResources();
        }
        this.m_mapTreePane = null;
        this.m_statisticsPane = null;
        this.m_animatorWorkflowPane = null;
        this.m_viewSplitPane = null;
        this.m_rootSplitPane = null;
        if (this.m_animationController != null) {
            this.m_animationController.releaseResources();
            this.m_animationController = null;
        }
        if (this.m_animatorDataModel != null) {
            this.m_animatorDataModel.releaseResources();
            this.m_animatorDataModel = null;
        }
        this.m_productName = null;
        this.m_theCore = null;
        this.m_animationDP = null;
        this.m_sessionInfo = null;
        this.m_initRunnable = null;
        this.m_animateRunnable = null;
        this.m_statPanelUpdateRunnable = null;
        this.m_timeUpdateRunnable = null;
        this.m_updateObject = null;
        if (this.m_menuBar != null) {
            this.m_menuBar.removeAll();
            this.m_menuBar = null;
        }
        if (this.m_fileMenu != null) {
            this.m_fileMenu.removeAll();
            this.m_fileMenu = null;
        }
        if (this.m_exitItem != null) {
            this.m_exitItem.removeActionListener(this);
            this.m_exitItem = null;
        }
        if (this.m_animationMenu != null) {
            this.m_animationMenu.removeAll();
            this.m_animationMenu.removeMenuListener(this);
            this.m_animationMenu = null;
        }
        if (this.m_startMenuItem != null) {
            this.m_startMenuItem.removeActionListener(this);
            this.m_startMenuItem = null;
        }
        if (this.m_stopMenuItem != null) {
            this.m_stopMenuItem.removeActionListener(this);
            this.m_stopMenuItem = null;
        }
        if (this.m_pauseMenuItem != null) {
            this.m_pauseMenuItem.removeActionListener(this);
            this.m_pauseMenuItem = null;
        }
        if (this.m_setPlaybackRateMenuItem != null) {
            this.m_setPlaybackRateMenuItem.removeActionListener(this);
            this.m_setPlaybackRateMenuItem = null;
        }
        if (this.m_viewMenu != null) {
            this.m_viewMenu.removeAll();
            this.m_viewMenu.removeMenuListener(this);
            this.m_viewMenu = null;
        }
        if (this.m_viewSelectedMapMenuItem != null) {
            this.m_viewSelectedMapMenuItem.removeActionListener(this);
            this.m_viewSelectedMapMenuItem = null;
        }
        if (this.m_viewStatisticsItem != null) {
            this.m_viewStatisticsItem.removeItemListener(this.m_viewStatisticsListener);
            this.m_viewStatisticsItem = null;
        }
        this.m_viewStatisticsListener = null;
        if (this.m_viewWorkflowTreeItem != null) {
            this.m_viewWorkflowTreeItem.removeItemListener(this.m_viewTreeInfoListener);
            this.m_viewWorkflowTreeItem = null;
        }
        this.m_viewTreeInfoListener = null;
        if (this.m_simulationMenu != null) {
            this.m_simulationMenu.removeMenuListener(this);
            this.m_simulationMenu.removeAll();
            this.m_simulationMenu = null;
        }
        if (this.m_stopSimulationMenuItem != null) {
            this.m_stopSimulationMenuItem.removeActionListener(this);
            this.m_stopSimulationMenuItem = null;
        }
        if (this.m_helpMenu != null) {
            this.m_helpMenu.removeAll();
            this.m_helpMenu = null;
        }
        if (this.m_contentsIndexItem != null) {
            this.m_contentsIndexItem.removeActionListener(this);
            this.m_contentsIndexItem = null;
        }
        if (this.m_aboutItem != null) {
            this.m_aboutItem.removeActionListener(this);
            this.m_aboutItem = null;
        }
        if (this.m_statusBar != null) {
            this.m_statusBar.removeMouseListener(this);
            this.m_statusBar = null;
        }
        this.m_msgLabel = null;
        if (this.m_stepNamesCheckBox != null) {
            this.m_stepNamesCheckBox.removeItemListener(this);
            this.m_stepNamesCheckBox = null;
        }
        if (this.m_routeNamesCheckBox != null) {
            this.m_routeNamesCheckBox.removeItemListener(this);
            this.m_routeNamesCheckBox = null;
        }
        if (this.m_milestoneAttrsCheckBox != null) {
            this.m_milestoneAttrsCheckBox.removeItemListener(this);
            this.m_milestoneAttrsCheckBox = null;
        }
        if (this.m_conditionAttrsCheckBox != null) {
            this.m_conditionAttrsCheckBox.removeItemListener(this);
            this.m_conditionAttrsCheckBox = null;
        }
        if (this.m_collectorAttrsCheckBox != null) {
            this.m_collectorAttrsCheckBox.removeItemListener(this);
            this.m_collectorAttrsCheckBox = null;
        }
        if (this.m_stepStatusCheckBox != null) {
            this.m_stepStatusCheckBox.removeItemListener(this);
            this.m_stepStatusCheckBox = null;
        }
        this.m_mainContainer = null;
        if (this.m_contentPane != null) {
            this.m_contentPane.removeAll();
            this.m_contentPane.setLayout(null);
            this.m_contentPane = null;
        }
        if (this.m_rootPane != null) {
            this.m_rootPane.removeAll();
            this.m_rootPane = null;
        }
        this.m_parentFrame = null;
        this.m_applet = null;
        if (this.m_mainPanel != null) {
            this.m_mainPanel.removeAll();
            this.m_mainPanel.setLayout(null);
            this.m_mainPanel = null;
        }
        if (this.m_toolbarPanel != null) {
            this.m_toolbarPanel.removeAll();
            this.m_toolbarPanel.setLayout(null);
            this.m_toolbarPanel = null;
        }
        if (this.m_animationToolBar != null) {
            this.m_animationToolBar.removeAll();
            this.m_animationToolBar = null;
        }
        if (this.m_startBtn != null) {
            this.m_startBtn.removeActionListener(this);
            this.m_startBtn.setToolTipText(null);
            this.m_startBtn = null;
        }
        if (this.m_pauseBtn != null) {
            this.m_pauseBtn.removeActionListener(this);
            this.m_pauseBtn.setToolTipText(null);
            this.m_pauseBtn = null;
        }
        if (this.m_stopBtn != null) {
            this.m_stopBtn.removeActionListener(this);
            this.m_stopBtn.setToolTipText(null);
            this.m_stopBtn = null;
        }
        if (this.m_viewToolBar != null) {
            this.m_viewToolBar.removeAll();
            this.m_viewToolBar = null;
        }
        if (this.m_viewSelectedMapBtn != null) {
            this.m_viewSelectedMapBtn.removeActionListener(this);
            this.m_viewSelectedMapBtn.setToolTipText(null);
            this.m_viewSelectedMapBtn = null;
        }
        if (this.m_helpToolBar != null) {
            this.m_helpToolBar.removeAll();
            this.m_helpToolBar = null;
        }
        if (this.m_contextAndIndexBtn != null) {
            this.m_contextAndIndexBtn.removeActionListener(this);
            this.m_contextAndIndexBtn.setToolTipText(null);
            this.m_contextAndIndexBtn = null;
        }
        if (this.m_mapInfoPanel != null) {
            this.m_mapInfoPanel.removeAll();
            this.m_mapInfoPanel.setLayout(null);
            this.m_mapInfoPanel = null;
        }
        if (this.m_workflowAndMapUI != null) {
            this.m_workflowAndMapUI.setText(null);
            this.m_workflowAndMapUI = null;
        }
        if (this.m_animationTimeUI != null) {
            this.m_animationTimeUI.setText(null);
            this.m_animationTimeUI = null;
        }
        this.m_currentWorkflow = null;
        this.m_currentMap = null;
        this.m_sync = null;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_contextAndIndexBtn || source == this.m_contentsIndexItem) {
            this.performContentsAndIndex();
        } else if (source == this.m_aboutItem) {
            this.performAboutItemAction();
        } else if (source == this.m_exitItem) {
            this.performExitItemAction();
        } else if (source == this.m_startBtn || source == this.m_startMenuItem) {
            this.performPlayAnimation();
        } else if (source == this.m_pauseBtn || source == this.m_pauseMenuItem) {
            this.performPauseAnimation();
        } else if (source == this.m_stopBtn || source == this.m_stopMenuItem) {
            this.performStopAnimation();
        } else if (source == this.m_viewSelectedMapBtn || source == this.m_viewSelectedMapMenuItem) {
            this.performViewSelecedMap();
        } else if (source == this.m_stopSimulationMenuItem) {
            this.performStopSimulation();
        } else if (source == this.m_setPlaybackRateMenuItem) {
            this.performSetPlaybackRate();
        } else {
            super.actionPerformed(e);
        }
    }

    void createAnimationThread() {
        if (this.m_animateThread != null) {
            return;
        }
        if (this.m_animationController == null) {
            this.m_animationController = new VWSIMAnimationController();
        }
        if (this.m_theCore == null) {
            this.m_theCore = this;
        }
        this.m_animateThread = new Thread[1];
        this.m_animateRunnable = new Runnable(){

            public void run() {
                while (VWSIMAnimatorCore.this.m_animatorDataModel == null || VWSIMAnimatorCore.this.m_animatorDataModel.getInitState() != 6 || VWSIMAnimatorCore.this.m_animatorWorkflowPane == null || VWSIMAnimatorCore.this.m_statisticsPane == null) {
                    if (VWSIMAnimatorCore.this.m_animatorDataModel == null || VWSIMAnimatorCore.this.m_animatorDataModel.getInitState() != 7) {
                        // empty if block
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (VWSIMAnimatorCore.this.m_animationController != null) {
                    if (!VWSIMAnimatorCore.this.m_animationController.isInitialized()) {
                        VWSIMAnimatorCore.this.m_animationController.initialize(VWSIMAnimatorCore.this.m_animatorDataModel, VWSIMAnimatorCore.this.m_animatorWorkflowPane);
                    }
                    VWSIMAnimatorCore.this.m_animationController.animate();
                }
            }
        };
        for (int i = 0; i < 1; ++i) {
            this.m_animateThread[i] = new Thread(this.m_animateRunnable, "VWSIMAnimationControllerThread" + i);
        }
        this.m_statPanelUpdateRunnable = new Runnable(){

            public void run() {
                while (VWSIMAnimatorCore.this.m_animatorDataModel == null || VWSIMAnimatorCore.this.m_animatorDataModel.getInitState() != 6 || VWSIMAnimatorCore.this.m_animatorWorkflowPane == null || VWSIMAnimatorCore.this.m_statisticsPane == null) {
                    if (VWSIMAnimatorCore.this.m_animatorDataModel == null || VWSIMAnimatorCore.this.m_animatorDataModel.getInitState() != 7) {
                        // empty if block
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (VWSIMAnimatorCore.this.m_animationController != null) {
                    if (!VWSIMAnimatorCore.this.m_animationController.isInitialized()) {
                        VWSIMAnimatorCore.this.m_animationController.initialize(VWSIMAnimatorCore.this.m_animatorDataModel, VWSIMAnimatorCore.this.m_animatorWorkflowPane);
                    }
                    VWSIMAnimatorCore.this.m_animationController.addAnimationUpdateListener(VWSIMAnimatorCore.this.m_statisticsPane);
                }
                VWSIMAnimatorCore.this.m_statisticsPane.updateInfo();
            }
        };
        this.m_statPanelUpdateThread = new Thread(this.m_statPanelUpdateRunnable, "VWSIMStatPanelInfoUpdateThread");
        this.m_timeUpdateRunnable = new Runnable(){

            public void run() {
                while (VWSIMAnimatorCore.this.m_animatorDataModel == null || VWSIMAnimatorCore.this.m_animatorDataModel.getInitState() != 6 || VWSIMAnimatorCore.this.m_animatorWorkflowPane == null || VWSIMAnimatorCore.this.m_statisticsPane == null) {
                    if (VWSIMAnimatorCore.this.m_animatorDataModel == null || VWSIMAnimatorCore.this.m_animatorDataModel.getInitState() != 7) {
                        // empty if block
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {}
                }
                if (VWSIMAnimatorCore.this.m_animationController != null) {
                    if (!VWSIMAnimatorCore.this.m_animationController.isInitialized()) {
                        VWSIMAnimatorCore.this.m_animationController.initialize(VWSIMAnimatorCore.this.m_animatorDataModel, VWSIMAnimatorCore.this.m_animatorWorkflowPane);
                    }
                    VWSIMAnimatorCore.this.m_animationController.addAnimationUpdateListener(VWSIMAnimatorCore.this.m_theCore);
                }
                while (!VWSIMAnimatorCore.this.m_bExit) {
                    try {
                        VWSIMAnimatorCore.this.updateAnimationTime();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                VWSIMAnimatorCore.this.m_animationController.removeAnimationUpdateListener(VWSIMAnimatorCore.this.m_theCore);
            }
        };
        this.m_timeUpdateThread = new Thread(this.m_timeUpdateRunnable, "VWSIMAnimatorCoreTimerThread");
    }

    private void startAnimationThreads() {
        if (this.m_bAnimateThreadsStarted) {
            return;
        }
        this.m_bAnimateThreadsStarted = true;
        for (int i = 0; i < 1; ++i) {
            if (this.m_animateThread[i] == null) continue;
            this.m_animateThread[i].start();
        }
        if (this.m_statPanelUpdateThread != null) {
            this.m_statPanelUpdateThread.start();
        }
        if (this.m_timeUpdateThread != null) {
            this.m_timeUpdateThread.start();
        }
    }

    public void menuSelected(MenuEvent e) {
        Object source = e.getSource();
        if (source == this.m_viewMenu) {
            boolean bTreePaneShown = true;
            if (this.m_viewWorkflowTreeItem != null) {
                bTreePaneShown = this.isWorkflowTreePaneShown();
                if (bTreePaneShown) {
                    this.m_viewWorkflowTreeItem.setSelected(true);
                } else {
                    this.m_viewWorkflowTreeItem.setSelected(false);
                }
            }
            if (this.m_viewStatisticsItem != null) {
                if (this.isStatisticsPaneShown()) {
                    this.m_viewStatisticsItem.setSelected(true);
                } else {
                    this.m_viewStatisticsItem.setSelected(false);
                }
            }
            this.m_viewSelectedMapMenuItem.setEnabled(bTreePaneShown && this.m_mapTreePane.isMapNodeSelected());
        } else if (source == this.m_animationMenu) {
            if (this.m_animationController != null) {
                int playMode = this.m_animationController.getPlayMode();
                if (this.m_startMenuItem != null) {
                    this.m_startMenuItem.setEnabled(playMode != 2);
                }
                if (this.m_pauseMenuItem != null) {
                    this.m_pauseMenuItem.setEnabled(playMode == 2);
                }
                if (this.m_stopMenuItem != null) {
                    this.m_stopMenuItem.setEnabled(playMode != 0);
                }
                if (this.m_setPlaybackRateMenuItem != null) {
                    this.m_setPlaybackRateMenuItem.setEnabled(playMode != 2);
                }
            }
        } else if (source == this.m_simulationMenu && this.m_stopSimulationMenuItem != null) {
            boolean bEnable = false;
            if (this.m_animatorDataModel != null) {
                bEnable = this.m_animatorDataModel.canStopSimulation();
            }
            this.m_stopSimulationMenuItem.setEnabled(bEnable);
        }
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animationUpdate(VWSIMAnimationUpdateEvent e) {
        if (this.m_animationController == null || this.m_animationController.getPlayMode() != 2) {
            return;
        }
        if (e == null || e.getSIMEvent() == null || e.isTimeout() || e.isError()) {
            if (e != null && e.isError()) {
                this.performStopAnimation();
                JOptionPane.showMessageDialog(this.m_parentFrame, VWSIMResource.s_errorAndAnimationStopped, this.getProductName(), 1, null);
            } else {
                this.performPauseAnimation();
                JOptionPane.showMessageDialog(this.m_parentFrame, VWSIMResource.s_noMoreEventsAnimationPaused, this.getProductName(), 1, null);
            }
        } else {
            boolean bFinished = false;
            Object object = this.m_updateObject;
            synchronized (object) {
                this.m_bNeedUpdate = true;
                if (e != null && (bFinished = e.isFinished())) {
                    this.m_bUpdateEndTime = true;
                }
            }
            if (bFinished && this.m_animationController != null && this.m_animationController.isFinished() && this.m_progress != 4) {
                this.m_progress = 4;
                this.performStopAnimation();
                this.setFinalAnimationTime();
                JOptionPane.showMessageDialog(this.m_parentFrame, VWSIMResource.s_animationPlaybackCompleted, this.getProductName(), 1, null);
            }
        }
    }

    private String getProductName() {
        if (this.m_productName == null) {
            this.m_productName = VWSIMResource.s_animatorTitle;
            try {
                this.m_productName = VWIDMBaseFactory.instance().getVWString(13).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_productName;
    }

    private void updateAnimationTimeUI(Date animationTime) {
        String timeString = null;
        if (animationTime != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
            timeString = dateFormat != null ? dateFormat.format(animationTime) : animationTime.toString();
        }
        ImageIcon icon = null;
        switch (this.m_progress) {
            case 1: {
                this.m_animationTimeUI.setText(timeString);
                icon = s_playingIcon;
                break;
            }
            case 2: {
                icon = s_pausedIcon;
                break;
            }
            case 3: {
                icon = s_stoppedIcon;
                break;
            }
            case 4: {
                this.m_animationTimeUI.setText(timeString);
                icon = s_completedIcon;
                break;
            }
        }
        this.m_animationTimeUI.setIcon(icon);
        this.m_mapInfoPanel.updateUI();
    }

    private void setFinalAnimationTime() {
        Date time;
        if (this.m_animationController != null && this.m_animationController.getPlayMode() == 0 && (time = this.m_animationController.getLastEventTime()) != null) {
            this.updateAnimationTimeUI(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnimationTime() {
        boolean bUpdate = false;
        Date animationTime = null;
        Object object = this.m_updateObject;
        synchronized (object) {
            bUpdate = false;
            if (this.m_bNeedUpdate) {
                this.m_bNeedUpdate = false;
                bUpdate = true;
            }
        }
        if (this.m_animationController != null) {
            if (this.m_bUpdateEndTime) {
                this.m_bUpdateEndTime = false;
                bUpdate = true;
            } else if (this.m_animationController.getPlayMode() == 2) {
                bUpdate = true;
            }
        }
        if (bUpdate) {
            animationTime = this.m_animationController.getAnimationTime();
            this.updateAnimationTimeUI(animationTime);
        }
    }

    static class ViewSplitPane
    extends JSplitPane {
        boolean m_bInitialized = false;
        VWSIMAnimatorCore m_animatorCore = null;

        ViewSplitPane(VWSIMAnimatorCore core) {
            this.m_animatorCore = core;
        }

        public void setInitialized(boolean initialized) {
            this.m_bInitialized = initialized;
        }

        public void setDividerLocation(int location) {
            super.setDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_animatorCore.updateWorkflowTreePaneViewStatus();
            }
        }

        public void setLastDividerLocation(int location) {
            super.setLastDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_animatorCore.updateWorkflowTreePaneViewStatus();
            }
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
        }

        void releaseResources() {
            this.m_animatorCore = null;
        }
    }

    static class RootSplitPane
    extends JSplitPane {
        boolean m_bInitialized = false;
        VWSIMAnimatorCore m_animatorCore = null;

        RootSplitPane(VWSIMAnimatorCore core) {
            this.m_animatorCore = core;
        }

        public void setInitialized(boolean initialized) {
            this.m_bInitialized = initialized;
        }

        public void setDividerLocation(int location) {
            super.setDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_animatorCore.updateStatisticsPaneViewStatus();
            }
        }

        public void setLastDividerLocation(int location) {
            super.setLastDividerLocation(location);
            if (this.m_bInitialized) {
                this.m_animatorCore.updateStatisticsPaneViewStatus();
            }
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
        }

        void releaseResources() {
            this.m_animatorCore = null;
        }
    }
}

